--[[
VPLanguage = lua
VPScriptMenuTitle = In Document
VPScriptSuperMenuTitle = Word Count
VPEndConfig
--]]

totalPageCount  = 0
totalWordCount  = 0

for pageKey in objc.values(document:keys()) do
    page = document:pageForKey(pageKey)
    
    -- voodoopad 3.0 supports multiple types of pages.  So we make sure it's a regular page type first.
    if (page:type() == VPPageType) then
        
        attString      = page:dataAsAttributedString()
        pageText       = attString:string()
        
        for w in string.gfind(pageText, ' ') do
            totalWordCount = totalWordCount + 1
        end

        for w in string.gfind(pageText, '\t') do
            totalWordCount = totalWordCount + 1
        end

        for w in string.gfind(pageText, ':') do
            totalWordCount = totalWordCount + 1
        end
        
        totalPageCount = totalPageCount + 1
    end
end

s = string.format("There are %d words in %d text pages", totalWordCount, totalPageCount)

objc.nsAlert("Document word count", s, nil, nil, nil)
